/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/


/*Most of function has additional argument using as flags to
  decide which input should be overwritten:
	1st bit overwrite pbXmlContext string 
	2nd bit overwrite cbXmlContext size
	3rd bit overwrite pwszNodeName string	
	4th bit overwrite pwszNodeName size
	5th bit Attribute name/CData has leading space
	6th bit Attribute name/CData has traling space
	7th bit attribute value/Data has leading space 
	8th bit attribute value/Data has trailing space
 */

#include <stdio.h>
//#include <stdlib.h>
// #include <string.h>
#include "tclib.h"
#include "tstutils.h"
#include "drmxmlbuilder.h"
#include "drmcrt.h"
#include "tOEMIMP.h"



static DRM_DWORD    cbXmlContext=0;
static _XMBContext *pbXmlContext=NULL;

DRM_RESULT TestXMLCreateDocument(long argc, char **argv);
DRM_RESULT TestXMLReallocDocument(long argc, char **argv);
DRM_RESULT TestXMLCloseDocument(long argc, char **argv);
DRM_RESULT TestXMLOpenNode(long argc, char **argv);
DRM_RESULT TestXMLCloseCurrNode(long argc, char **argv);
DRM_RESULT TestXMLGetCurrNodeName(long argc, char **argv);
DRM_RESULT TestXMLGetContextSize(long argc, char **argv);
DRM_RESULT TestXMLAddAttribute(long argc, char **argv);
DRM_RESULT TestXMLAddData(long iIndex, char **argv); 
DRM_RESULT TestXMLAddCData(long iIndex, char **argv); 
DRM_RESULT TestXMLAppendNode(long iIndex, char **argv); 
 
 
/*  Reinitialize all if iIndex=0*/
DRM_RESULT TestXMLUtilReinitialize_XMLB(long iIndex, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	if (argv!=NULL){
		iIndex=(int)OEM_atoi(argv[0]);
	}

 	if(iIndex==0 ||iIndex==1){ 
		DX_VOS_MemFree(pbXmlContext);
		pbXmlContext=NULL;
   	}
 	if(iIndex==0 ||iIndex==2){ 
		cbXmlContext=0; 
	}
   
	return dr;
}

DRM_RESULT TestXMLCreateDocument(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pwszRootNodeName = {0,0};
	int iRootNodeNameNullFlag=0;
	DRM_WCHAR pwszLocalString[512]={0};
 
 	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLCreateDocument: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 5 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<5){
		Log("Trace", "\t\tFrom TestXMLCreateDocument: error in number of arguments.");
        ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[0])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[4])){
 		Log("Trace", "\t\tFrom TestXMLCreateDocument: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[4]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
		TestXMLUtilReinitialize_XMLB(1,NULL);
		if(argv[1]!=NULL){
		 	/*the 2nd bit is to overwrite cbXmlContext size*/ 
			if(iOption&2){
				cbXmlContext=(DRM_DWORD)OEM_atol(argv[0]);
				pbXmlContext=(_XMBContext*)DX_VOS_MemMalloc(cbXmlContext*sizeof(DRM_BYTE)+1);
				if(!pbXmlContext)
					ChkDR(DRM_E_FAIL);
   			}
			else{
				cbXmlContext=(DRM_DWORD)DX_VOS_StrLen(argv[1]);
				pbXmlContext=(_XMBContext*)DX_VOS_MemMalloc(cbXmlContext*sizeof(DRM_BYTE)+1);
				if(!pbXmlContext)
					ChkDR(DRM_E_FAIL);
 	 			DX_VOS_FastMemCpy(pbXmlContext, argv[1], cbXmlContext+1);
			}
  		}
   	}
 	if(iOption&4){
 		if(argv[2]!=NULL){
			if(DX_VOS_StrCmp(argv[2],"nullstring")){
 				OEM_mbstowcs(pwszLocalString, argv[2], DX_VOS_StrLen(argv[2])+1);
				pwszRootNodeName.pwszString=pwszLocalString;
				pwszRootNodeName.cchString=(DRM_DWORD)DRM_wcslen(pwszLocalString);
			}
			else{
				pwszRootNodeName.pwszString=NULL;
				pwszRootNodeName.cchString=0;
			}	
		}
		else{
			iRootNodeNameNullFlag=1;
		}
	}
	if(iOption&8)
		pwszRootNodeName.cchString=(DRM_DWORD)OEM_atol(argv[3]);

	ChkDR(DRM_XMB_CreateDocument(cbXmlContext, pbXmlContext, iRootNodeNameNullFlag>0?NULL:&pwszRootNodeName));
   
ErrorExit:
	/*pbXmlContext is freed somewhere else*/
  	return dr;
}

DRM_RESULT TestXMLReallocDocument(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	_XMBContext *pbLocalXmlContext=NULL;
	_XMBContext *pbNewXmlContext=NULL;
	DRM_DWORD cbNewXmlContext=0;
	int j=0;

 	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLReallocDocument: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLReallocDocument: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])){ 
 		Log("Trace", "\t\tFrom TestXMLReallocDocument: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}
 	cbNewXmlContext=(DRM_DWORD)OEM_atol(argv[1]);
  	if(argv[2]!=NULL){
		pbNewXmlContext=(_XMBContext*)DX_VOS_MemMalloc(cbNewXmlContext+1);
		if(!pbNewXmlContext)
			ChkDR(DRM_E_FAIL);
 		DX_VOS_MemSet(pbNewXmlContext, 0, cbNewXmlContext+1);
	}
	if(j==1){
		ChkDR(DRM_XMB_ReallocDocument(pbLocalXmlContext,cbNewXmlContext,pbNewXmlContext));
	}
	else{
	 	ChkDR(DRM_XMB_ReallocDocument(pbXmlContext,cbNewXmlContext,pbNewXmlContext));
	}
	/*save the new pbXmlContext*/
	TestXMLUtilReinitialize_XMLB(1,NULL);
	pbXmlContext=pbNewXmlContext;
ErrorExit:
 	DX_VOS_MemFree(pbLocalXmlContext);
	pbNewXmlContext=NULL;
	return dr;
}

DRM_RESULT TestXMLCloseDocument(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_STRING pszXMLString = {0,0};
	DRM_WCHAR szArrayXMLString[2000]={0};
	DRM_WCHAR szVerifyArrayXMLString[2000]={0};
	_XMBContext *pbLocalXmlContext=NULL;
	int j=0,iStringNullFlag=0;
 	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLCloseDocument: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 5 arguments. The last one is used to decide whether we need to overwrite the context*/
	/*4th is used to verify the xml content*/
	if(argc<5){
		Log("Trace", "\t\tFrom TestXMLCloseDocument: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[4])){ 
	  	Log("Trace", "\t\tFrom TestXMLCloseDocument: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[4]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayXMLString, argv[1], DX_VOS_StrLen(argv[1])+1);
 			pszXMLString.pwszString=szArrayXMLString;
			pszXMLString.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLString);
		}
	}
	else{
		iStringNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_CloseDocument(pbLocalXmlContext,iStringNullFlag>0?NULL:&pszXMLString));
 	}	
	else{
		ChkDR(DRM_XMB_CloseDocument(pbXmlContext,iStringNullFlag>0?NULL:&pszXMLString));
 	}
	/*verify the result*/
 	if(argv[3]!=NULL){
		OEM_mbstowcs(szVerifyArrayXMLString, argv[3], DX_VOS_StrLen(argv[3])+1);
		if(DRM_wcsncmp(szVerifyArrayXMLString,pszXMLString.pwszString,DRM_wcslen(szVerifyArrayXMLString))){
			ChkDR(DRM_E_FAIL);
		}
	}	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}
  
DRM_RESULT TestXMLOpenNode(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pszNodeName = {0,0};
	DRM_WCHAR szArrayNodeName[512]={0};
	_XMBContext *pbLocalXmlContext=NULL;
	int j=0, iNodeNameNullFlag=0;
 	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLOpenNode: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLOpenNode: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLOpenNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

	if(iOption&4){
 		if(argv[1]!=NULL){
			if(DX_VOS_StrCmp(argv[1],"nullstring")){
 				OEM_mbstowcs(szArrayNodeName, argv[1], DX_VOS_StrLen(argv[1])+1);
				pszNodeName.pwszString=szArrayNodeName;
				pszNodeName.cchString=(DRM_DWORD)DRM_wcslen(szArrayNodeName);
			}
			else{
				pszNodeName.pwszString=NULL;
				pszNodeName.cchString=0;
			}	
 		}
		else{
			iNodeNameNullFlag=1;
		}
	}
	if(iOption&8)
		pszNodeName.cchString=(DRM_DWORD)OEM_atol(argv[2]);
	
	if(j==1){
		ChkDR(DRM_XMB_OpenNode(pbLocalXmlContext,iNodeNameNullFlag>0?NULL:&pszNodeName));
 	}	
	else{
		ChkDR(DRM_XMB_OpenNode(pbXmlContext,iNodeNameNullFlag>0?NULL:&pszNodeName));
 	}
	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLCloseCurrNode(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_STRING pszXMLFragment = {0,0};
	DRM_WCHAR szArrayXMLFragment[2048]={0};
	_XMBContext *pbLocalXmlContext=NULL;
	int j=0,iFragmentNullFlag=0;

 	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLCloseCurrNode: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLCloseCurrNode: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLCloseCurrNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayXMLFragment, argv[1], DX_VOS_StrLen(argv[1])+1);
 			pszXMLFragment.pwszString=szArrayXMLFragment;
			pszXMLFragment.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLFragment);
		}
	}
	else{
		iFragmentNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_CloseCurrNode(pbLocalXmlContext,iFragmentNullFlag>0?NULL:&pszXMLFragment));
 	}	
	else{
		ChkDR(DRM_XMB_CloseCurrNode(pbXmlContext,iFragmentNullFlag>0?NULL:&pszXMLFragment));
 	}
	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLGetCurrNodeName(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_STRING pszNodeName = {0,0};
  	DRM_WCHAR szArrayNodeName[256]={0}; 
	_XMBContext *pbLocalXmlContext=NULL;
	int iNodeNameNullFlag=0, j=0; 

	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLGetCurrNodeName: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLGetCurrNodeName: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLGetCurrNodeName: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayNodeName, argv[1], DX_VOS_StrLen(argv[1])+1);
 			pszNodeName.pwszString=szArrayNodeName;
			pszNodeName.cchString=(DRM_DWORD)DRM_wcslen(szArrayNodeName);
		}
	}
	else{
		iNodeNameNullFlag=1;
   	}
	
	if(j==1){
 		ChkDR(DRM_XMB_GetCurrNodeName(pbLocalXmlContext,iNodeNameNullFlag>0?NULL:&pszNodeName));
 	}	
	else{
		ChkDR(DRM_XMB_GetCurrNodeName(pbXmlContext,iNodeNameNullFlag>0?NULL:&pszNodeName));
 	}
	Log("Trace", "\t\tThe obtained node name is:%S", pszNodeName.pwszString);
	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLGetContextSize(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
 	DRM_DWORD cbLocalXmlContext=0;
	_XMBContext *pbLocalXmlContext=NULL;
	int j=0;
	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLGetContextSize: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 3 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<3){
		Log("Trace", "\t\tFrom TestXMLGetContextSize: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[2])){ 
	  	Log("Trace", "\t\tFrom TestXMLGetContextSize: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[2]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}
	cbLocalXmlContext=(long)OEM_atol(argv[1]);;

	if(j==1){
		ChkDR(DRM_XMB_GetContextSize(pbLocalXmlContext,&cbLocalXmlContext));
 	}	
	else{
		ChkDR(DRM_XMB_GetContextSize(pbXmlContext,&cbLocalXmlContext));
 	}
	/*overwrite the context size*/
	if(iOption&2){
		cbXmlContext=cbLocalXmlContext;	 
	}
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLAddAttribute(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pszAttrName = {0,0};
  	DRM_WCHAR szArrayAttrName[512]={0}; 
	DRM_WCHAR szArrayAttr[512]={0}; 
	DRM_CONST_STRING pszAttrValue = {0,0};
  	DRM_WCHAR szArrayAttrValue[512]={0}; 
	_XMBContext *pbLocalXmlContext=NULL;
	int iNodeNameNullFlag=0,iNodeValueNullFlag=0, j=0; 
	
	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLAddAttribute: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 6 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<6){
		Log("Trace", "\t\tFrom TestXMLAddAttribute: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[4])||!IsDigitalOnlyString(argv[5])){ 
	  	Log("Trace", "\t\tFrom TestXMLAddAttribute: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[5]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayAttrName, argv[1], DX_VOS_StrLen(argv[1])+1);
			if((iOption&16)||(iOption&32)){ 
				if(iOption&16){
					        /*replacing swprintf , as swprintf may not be available on all platforms*/
					OEM_wcscat(&szArrayAttr[0],(const DRM_WCHAR *)" ");
					OEM_wcscat(&szArrayAttr[1], (const DRM_WCHAR *)szArrayAttrName);
 				}
				if(iOption&32){
   					OEM_wcscat(&szArrayAttr[0], (const DRM_WCHAR *)szArrayAttrName);
				}
				pszAttrName.pwszString=szArrayAttr;
				pszAttrName.cchString=(DRM_DWORD)DRM_wcslen(szArrayAttr);
 			}
			else{
				pszAttrName.pwszString=szArrayAttrName;
				pszAttrName.cchString=(DRM_DWORD)DRM_wcslen(szArrayAttrName);
			}
		}
	}
	else{
		iNodeNameNullFlag=1;
   	}
	if(argv[3]!=NULL){
		if(DX_VOS_StrCmp(argv[3], "nullstring")){
  			OEM_mbstowcs(szArrayAttrValue, argv[3], DX_VOS_StrLen(argv[3])+1);
			if((iOption&64)||(iOption&128)){ 
				if(iOption&64){
   					OEM_wcscat(&szArrayAttr[0],(const DRM_WCHAR *)" ");
   					OEM_wcscat(&szArrayAttr[1], szArrayAttrValue);
				}
				if(iOption&128){
   					OEM_wcscat(&szArrayAttr[0], szArrayAttrValue);
				}
				pszAttrValue.pwszString=szArrayAttr;
				pszAttrValue.cchString=(DRM_DWORD)DRM_wcslen(szArrayAttr);
 			}
			else{
				pszAttrValue.pwszString=szArrayAttrValue;
				pszAttrValue.cchString=(DRM_DWORD)DRM_wcslen(szArrayAttrValue);
			}
		}
	}
	else{
		iNodeValueNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_AddAttribute(pbLocalXmlContext,iNodeNameNullFlag>0?NULL:&pszAttrName,iNodeValueNullFlag>0?NULL:&pszAttrValue));
 	}	
	else{
		ChkDR(DRM_XMB_AddAttribute(pbXmlContext,iNodeNameNullFlag>0?NULL:&pszAttrName,iNodeValueNullFlag>0?NULL:&pszAttrValue));
 	}
 	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLAddData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pszXMLData = {0,0};
  	DRM_WCHAR szArrayXMLData[512]={0}; 
	DRM_WCHAR szArrayXMLDataSpace[512]={0}; 
	_XMBContext *pbLocalXmlContext=NULL;
	int iXmlDataNullFlag=0, j=0; 

	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLAddData: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLAddData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLAddData: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayXMLData, argv[1], DX_VOS_StrLen(argv[1])+1);
			if((iOption&64)||(iOption&128)){ 
				if(iOption&64){
   					OEM_wcscat(&szArrayXMLDataSpace[0], (const DRM_WCHAR *)" ");
   					OEM_wcscat(&szArrayXMLDataSpace[1], szArrayXMLData);
 				}
				if(iOption&128){
   					OEM_wcscat(&szArrayXMLDataSpace[0], szArrayXMLData);
				}
				pszXMLData.pwszString=szArrayXMLDataSpace;
				pszXMLData.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLDataSpace);
			}
			else{
 				pszXMLData.pwszString=szArrayXMLData;
				pszXMLData.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLData);
			}
		}
	}
	else{
		iXmlDataNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_AddData(pbLocalXmlContext,iXmlDataNullFlag>0?NULL:&pszXMLData));
 	}	
	else{
		ChkDR(DRM_XMB_AddData(pbXmlContext,iXmlDataNullFlag>0?NULL:&pszXMLData));
 	}
 	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLAddCData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pszXMLCData = {0,0};
  	DRM_WCHAR szArrayXMLCData[512]={0}; 
	DRM_WCHAR szArrayXMLCDataSpace[512]={0}; 
	_XMBContext *pbLocalXmlContext=NULL;
	int iXmlCDataNullFlag=0, j=0; 

	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLAddCData: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLAddCData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLAddCData: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring")){
  			OEM_mbstowcs(szArrayXMLCData, argv[1], DX_VOS_StrLen(argv[1])+1);
			if((iOption&16)||(iOption&32)){ 
				if(iOption&16){
    				OEM_wcscat(&szArrayXMLCDataSpace[0],(const DRM_WCHAR *) " ");
    				OEM_wcscat(&szArrayXMLCDataSpace[1], szArrayXMLCData);
 				}
				if(iOption&32){
   					OEM_wcscat(&szArrayXMLCDataSpace[0], szArrayXMLCData);
				}
				pszXMLCData.pwszString=szArrayXMLCDataSpace;
				pszXMLCData.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLCDataSpace);
			}
			else{
				pszXMLCData.pwszString=szArrayXMLCData;
				pszXMLCData.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLCData);
			}
		}
	}
	else{
		iXmlCDataNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_AddCData(pbLocalXmlContext,iXmlCDataNullFlag>0?NULL:&pszXMLCData));
 	}	
	else{
		ChkDR(DRM_XMB_AddCData(pbXmlContext,iXmlCDataNullFlag>0?NULL:&pszXMLCData));
 	}
 	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
  	return dr;
}

DRM_RESULT TestXMLAppendNode(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long i,iOption=0;
	DRM_CONST_STRING pwszXMLString = {0};
	_XMBContext *pbLocalXmlContext=NULL;
	int iXmlStringNullFlag=0, j=0; 

	for(i=0; i<argc; i++){
		Log("Trace", "\t\tFrom TestXMLAppendNode: argv[%d]=%s", i, argv[i]);
	}
 	/*at least 4 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<4){
		Log("Trace", "\t\tFrom TestXMLAppendNode: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[2])||!IsDigitalOnlyString(argv[3])){ 
	  	Log("Trace", "\t\tFrom TestXMLAppendNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
   	iOption=(long)OEM_atol(argv[3]);
	/*the 1st bit is to overwrite pbXmlContext*/ 
	if(iOption&1){
 		if(argv[0]!=NULL){
 			pbLocalXmlContext=(_XMBContext*)DX_VOS_MemMalloc(DX_VOS_StrLen(argv[0])*sizeof(DRM_BYTE)+1);
			if(!pbLocalXmlContext)
				ChkDR(DRM_E_FAIL);
 	 		DX_VOS_FastMemCpy(pbLocalXmlContext, argv[0], DX_VOS_StrLen(argv[0])+1);
  		}
		j=1;
   	}

 	if(argv[1]!=NULL){
		if(DX_VOS_StrCmp(argv[1], "nullstring"))
			MakeDRMString(&pwszXMLString, argv[1]);
	}
	else{
		iXmlStringNullFlag=1;
   	}
	
	if(j==1){
		ChkDR(DRM_XMB_AppendNode(pbLocalXmlContext,iXmlStringNullFlag>0?NULL:&pwszXMLString));
 	}	
	else{
		ChkDR(DRM_XMB_AppendNode(pbXmlContext,iXmlStringNullFlag>0?NULL:&pwszXMLString));
 	}
 	 
ErrorExit:
	DX_VOS_MemFree(pbLocalXmlContext);
	DX_VOS_MemFree((void*)pwszXMLString.pwszString);
  	return dr;
}

 
/* Get the default implementations for WrapTestRun, PreTestCase and PostTestCase */
/*
IMPLEMENT_DEFAULT_PRETESTCASE_AND_POSTTESTCASE
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_APIMAP(testxmlbuilder_ansi, "DailyTestXMLBuilder")
 	API_ENTRY(TestXMLCreateDocument)
	API_ENTRY(TestXMLReallocDocument)
	API_ENTRY(TestXMLCloseDocument)
	API_ENTRY(TestXMLOpenNode)
	API_ENTRY(TestXMLCloseCurrNode)
	API_ENTRY(TestXMLGetCurrNodeName)
	API_ENTRY(TestXMLGetContextSize)
	API_ENTRY(TestXMLAddAttribute)
	API_ENTRY(TestXMLAddData)
	API_ENTRY(TestXMLAddCData)
	API_ENTRY(TestXMLAppendNode)
	API_ENTRY(TestXMLUtilReinitialize)
END_APIMAP
*/
